#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* #include <ctype.h> */
//#include "getCharacter.h"
//#include "openFile.h"

struct cmd_args
{
  int arg0;
  char arg1[255];
  char arg2[255];
};

int parser(struct cmd_args args, int argc, char **argv);

int readCharacter(FILE *source, int option);


int 
main (int argc, char **argv)
{
  

  struct cmd_args args;
  
  parser(args, argc, argv);
  

  return 0;
  /* printf("%d\n", args.arg0);  */
  /* printf("%s\n", args.arg1); */
  /* printf("%s\n", args.arg2);  */
}

int 
parser (struct cmd_args args, int argc, char **argv)
{
  
  args.arg0 = argc; 

  switch (argc)
    {
    case 1:
      readCharacter(stdin, 0);
      break;
      
    case 2:
      if (strlen(argv[1]) > 255)
	{
	  fprintf(stderr, "Too many characters!\n");
	return EXIT_FAILURE;
	}
      
      strcpy(args.arg1, argv[1]);
      
      if (!strcmp(args.arg1, "-"))
	readCharacter (stdin, 0);
      
      else if (!strcmp(args.arg1, "-l") || (!strcmp(args.arg1, "--lines")))
	readCharacter (stdin, 2);
      
      else if (!strcmp(args.arg1, "-c") || (!strcmp(args.arg1, "--chars")))
	readCharacter (stdin, 1);
      
      else 
	openFile(args, 0);
            
      break;
    
    case 3:
      if (strlen(argv[1]) > 255 || strlen(argv[2]) > 255)
	{
	  fprintf(stderr, "Too many characters!\n");
	  return EXIT_FAILURE;
	}
      
      strcpy(args.arg1, argv[1]);
      strcpy(args.arg2, argv[2]);
      
      if (!strcmp(args.arg1, "-c") || 
	  !strcmp(args.arg1, "--chars") )
	{
	  if (!strcmp(args.arg2, "-"))
	    readCharacter(stdin, 1);
	  else
	    openFile(args, 1);
	}
      if (!strcmp(args.arg1, "-l") 
	  || !strcmp(args.arg1, "--lines" ))
	{
	  if (!strcmp(args.arg2, "-"))
	    readCharacter(stdin, 2);
	  else
	    openFile(args, 2);
	}
    
      break;
      
      default:
	  fprintf(stderr, "Too many arguments\n");
	  break;
    }

  return 0;
}


int 
readCharacter(FILE *source, int option)
{
  // printf("i am here");
  
  unsigned int lines=0;
  unsigned int characters = 0;
  unsigned int words = 0;

  char ch;
  char tmp = ' '; /* temp buffer, initialized to a known condition */

  while((ch = fgetc(source)))
    {
      if (ch == EOF)
	{
	  if (tmp != ' ' && tmp != '\n')
	    {
	      words++;
	      /* printf("_WORDS++_"); */
	    }
	  break;
	}

      printf("%c", ch); /* prints the test as it reads is */

      characters++;

      if (ch == '\n')
	{
	  lines++;
	  /* printf("_LINES++_");  */
	}

      if (ch == ' ' && (tmp > 32))
	{
	  words++;
	  /* printf("_WORDS++_"); */
	}
      else if (ch == '\n' && (tmp > 32))
	{
	  words++;
	  /* printf("_WORDS++_");    */
	}

      tmp = ch; /* tmp receives the now outdated ch value */
    }
  
  switch (option)
    {
    case 0:
      fprintf(stdout,"%i \n",words);
      break;
    case 1:
      fprintf(stdout, "%i\n", characters);
      break;
    case 2:
      fprintf(stdout, "%i\n", lines);
      break;
    }
  
  
  return 0;
}

int 
  openFile (struct cmd_args args, int option)
{
  FILE *fp;
  char filename[255];
  
  if (args.arg0 == 2)
    {
    fp = fopen(args.arg1, "r");
    strcpy(filename, args.arg1);
    }
  else
    {
    fp = fopen(args.arg2, "r");
    strcpy(filename, args.arg1);
    }
  
  //printf("%s\n", filename);

  //  fp = fopen(filename, "r");
  
  if (fp == NULL)
    {
      fprintf(stderr, "No such file or directory\n");
      exit(EXIT_FAILURE);
    }
  else
    {
      //printf("File found\n");
      readCharacter(fp, option);
    }
  return EXIT_SUCCESS;
}
  


